  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 24 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_RsaAsymAuthenticator.c#1:csrc:1
   *  \author  taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "stdio.h"
#include "SST_SEP_TST.h"
#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "SEP_ATP_UTIL_funcs.h"

extern TST_ATP_RsaAuthTestDataStruct* TST_ATP_RsaAuthObjectTestData;
extern DxUint8_t*    GlobalMemBuff;
extern DxUint8_t*    CurrGlobalMemBuff;
/*****************************************************************************
 * Function Name:
 *  SEPQA_SST_RsaAsymAuthenticator
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the creation, deletion, modification, opening, closing and usage of an asymmetric key authenticator object.
 * And demonstration on the use of transaction with authenticator objects.
 *  
 * Algorithm:
 *    1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
 *    2.  Create a new session by calling: SST_SessionCreate.
 *    3.  Open a transaction by calling: SST_TransactionStart.
 *    4.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorPubKeyRSACreate.
 *    5.  Close the transaction by calling: SST_TransactionClose.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Open the new authenticator by calling: 
 *        i.   SST_AuthenticatorChallengeGet 
 *        ii.  CRYS_RSA_PSS_Sign
 *        iii. SST_AuthenticationOpen.
 *    8.  Close the transaction by calling: SST_TransactionClose.
 *    9.  Open a transaction by calling: SST_TransactionStart.
 *    10. Insert a new data object by calling: SST_InsertData.
 *    11. Close the authenticator by calling: SST_AuthenticationClose.
 *    12. Open the authenticator by calling: 
 *        i.   SST_AuthenticatorChallengeGet 
 *        ii.  CRYS_RSA_PSS_Sign
 *        iii. SST_AuthenticationOpen.
 *    13. Close the transaction by calling: SST_TransactionClose.
 *    14. Open a transaction by calling: SST_TransactionStart.
 *    15. Delete the data by calling: SST_DeleteData.
 *    16. Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    17. Close the transaction by calling: SST_TransactionClose.
 *    18. Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/
DxError_t SEPQA_SST_RsaAsymAuthenticator ( void )
{
    /********* TST Variables Definitions ************/
    DxUint32_t                  TST_index = 0;
    DxChar                      TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_RsaAsymAuthenticator";
    SSTSessionId_t              TST_SessionId; 
    DxUint32_t                  TST_Status = 0;
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle,TST_DataHandle;
    SSTChallengeId_t            TST_ChallengeId;
    SSTDataType_t               TST_SimpleData = TST_DATA_OBJECT;
    CRYS_RSAUserPrivKey_t*      TST_CRYS_RSAUserPrivKey  = DX_NULL;
    CRYS_RSAPrivUserContext_t*  TST_CRYS_RSAPrivUserContext = DX_NULL;

    /********* TST Variables initialization *********/
    TST_Status = TESTPASS;
    TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
    TST_DataHandle.objId = SST_HANDLE_RANDOM_GENERATE;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************** SEPQA_SST_RsaAsymAuthenticator Test *************** \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));


    /*Allocate buffers*/

    /* allocate buffer from GlobalMemBuff for TST_CRYS_RSAUserPrivKey*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_RSAUserPrivKey_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_CRYS_RSAUserPrivKey=(CRYS_RSAUserPrivKey_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_CRYS_RSAUserPrivKey allocation",
                             "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff=CurrGlobalMemBuff+sizeof(CRYS_RSAUserPrivKey_t);


    /* allocate buffer from GlobalMemBuff for TST_CRYS_RSAPrivUserContext*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_RSAPrivUserContext_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_CRYS_RSAPrivUserContext=(CRYS_RSAPrivUserContext_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_CRYS_RSAPrivUserContext allocation",
                             "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff=CurrGlobalMemBuff+sizeof(CRYS_RSAPrivUserContext_t);



    /* Build the Private Key for CRYS usage */
    /*--------------------------------------*/
    TST_Status = CRYS_RSA_Build_PrivKey(TST_CRYS_RSAUserPrivKey,
                                       TST_ATP_RsaAuthObjectTestData[TST_index].TST_D,
                                       (DxUint16_t)TST_ATP_RsaAuthObjectTestData[TST_index].TST_DSizeInBytes,
                                       TST_ATP_RsaAuthObjectTestData[TST_index].TST_E,
                                       (DxUint16_t)TST_ATP_RsaAuthObjectTestData[TST_index].TST_ESizeInBytes,
                                       TST_ATP_RsaAuthObjectTestData[TST_index].TST_N,
                                       (DxUint16_t)TST_ATP_RsaAuthObjectTestData[TST_index].TST_NSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_Build_PrivKey",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_SessionId",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Create a new RSA authenticator */
    /*--------------------------------*/
    TST_Status = SST_AuthenticatorPubKeyRSACreate(TST_TransactionId,
                                                  TST_ATP_RsaAuthObjectTestData[TST_index].TST_N,
                                                  TST_ATP_RsaAuthObjectTestData[TST_index].TST_E,
                                                  TST_ATP_RsaAuthObjectTestData[TST_index].TST_ESizeInBytes,
                                                  &TST_AuthHandle,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPubKeyRSACreate",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);



    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);



    /* re-open a transaction for operations */
    /*--------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);



    /* Open the authentication */
    /*-------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_RsaAuthObjectTestData[TST_index].TST_ChallengeBuff,
                                               TST_ATP_RsaAuthObjectTestData[TST_index].TST_ChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Sign the Challenge buffer */
    TST_Status = CRYS_RSA_PSS_Sign(TST_CRYS_RSAPrivUserContext,
                                   TST_CRYS_RSAUserPrivKey,
                                   CRYS_RSA_HASH_SHA1_mode,
                                   CRYS_PKCS1_MGF1,
                                   20,
                                   TST_ATP_RsaAuthObjectTestData[TST_index].TST_ChallengeBuff,
                                   TST_ATP_RsaAuthObjectTestData[TST_index].TST_ChallengeBuffSize,
                                   TST_ATP_RsaAuthObjectTestData[TST_index].TST_SignedChallengeBuff,
                                   &TST_ATP_RsaAuthObjectTestData[TST_index].TST_SignedChallengeBuffSize);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_PSS_Sign",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_RsaAuthObjectTestData[TST_index].TST_SignedChallengeBuff,
                                        TST_ATP_RsaAuthObjectTestData[TST_index].TST_SignedChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);




    /* re-open a transaction for operations */
    /*--------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Insert a new Data object */
    /*--------------------------*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_AuthHandle,
                               TST_ATP_RsaAuthObjectTestData[TST_index].TST_Data,
                               TST_ATP_RsaAuthObjectTestData[TST_index].TST_DataSize,
                               DX_TRUE,
                               TST_SimpleData,
                               &TST_DataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Close the authentication */
    /*--------------------------*/
    TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Re-open the authentication */
    /*----------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_RsaAuthObjectTestData[TST_index].TST_NewChallengeBuff,
                                               TST_ATP_RsaAuthObjectTestData[TST_index].TST_NewChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Sign the Challenge buffer */
    TST_Status = CRYS_RSA_PSS_Sign(TST_CRYS_RSAPrivUserContext,
                                   TST_CRYS_RSAUserPrivKey,
                                   CRYS_RSA_HASH_SHA1_mode,
                                   CRYS_PKCS1_MGF1,
                                   20,
                                   TST_ATP_RsaAuthObjectTestData[TST_index].TST_NewChallengeBuff,
                                   TST_ATP_RsaAuthObjectTestData[TST_index].TST_NewChallengeBuffSize,
                                   TST_ATP_RsaAuthObjectTestData[TST_index].TST_SignedChallengeBuff,
                                   &TST_ATP_RsaAuthObjectTestData[TST_index].TST_SignedChallengeBuffSize);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_PSS_Sign",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                       TST_AuthHandle,
                                       TST_ATP_RsaAuthObjectTestData[TST_index].TST_SignedChallengeBuff,
                                       TST_ATP_RsaAuthObjectTestData[TST_index].TST_SignedChallengeBuffSize,
                                       TST_ChallengeId,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);



    /* re-open a transaction for operations */
    /*--------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Delete the data */
    /*-----------------*/
     TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,  
                                TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);



    /* Close the authentication */
    /*--------------------------*/
    TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Delete the authenticator */
    /*--------------------------*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);



    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               "SEPQA_SST_RsaAsymAuthenticator",TST_MasterTestName);


EXIT_ON_ERROR:
    return TST_Status;

}/* End of SEPQA_SST_RsaAsymAuthenticator */